/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.IReactiveMaterial;
import dev.toma.gunsrpg.common.item.guns.util.IAdditionalShootData;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractExplosiveLauncher
extends GunItem
implements IAdditionalShootData {
    public AbstractExplosiveLauncher(String name, Item.Properties properties) {
        super(name, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addExtraData(PropertyContext context, PlayerEntity player, ItemStack stack, IAmmoMaterial material) {
        if (material instanceof IReactiveMaterial) {
            IReactiveMaterial reactiveMaterial = (IReactiveMaterial)((Object)material);
            IReaction reaction = reactiveMaterial.getReaction();
            context.setProperty(Properties.REACTION, reaction);
        }
    }

    @Override
    protected void prepareForShooting(AbstractProjectile projectile, LivingEntity shooter) {
        GunItem gun;
        IAmmoMaterial material;
        ItemStack stack = shooter.func_184614_ca();
        if (stack.func_77973_b() instanceof GunItem && (material = (gun = (GunItem)stack.func_77973_b()).getMaterialFromNBT(stack)) instanceof IReactiveMaterial) {
            IReaction reaction = ((IReactiveMaterial)((Object)material)).getReaction();
            projectile.setProperty(Properties.REACTION, reaction);
            reaction.writeInitialData(projectile, material, shooter);
        }
    }
}

